/*
 * Decompiled with CFR 0.152.
 */
package com.rovio.rtool.mobile.ui;

import com.rovio.rtool.mobile.Core;
import com.rovio.rtool.mobile.ui.ContentItem;
import com.rovio.rtool.mobile.ui.MenuPage;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MenuItem {
    public MenuPage page = null;
    public boolean enabled = true;
    public int action = -1;
    public int pageLink = -1;
    public ContentItem content;
    public int[] m_formattingBlockA;
    private boolean m_dynamicFont = false;
    private int[] m_fontFace = null;
    private int[] m_fontStyle = null;
    private int[] m_fontSize = null;
    private int[] m_colors = null;
    private int[] m_effectColors = null;

    public MenuItem() {
    }

    public MenuItem(String string, int n, MenuPage menuPage) {
        this.page = menuPage;
        this.setContent(string, n);
    }

    public MenuItem(String string, int n, MenuPage menuPage, int[] nArray, int[] nArray2, boolean bl, int[] nArray3, int[] nArray4, int[] nArray5, int n2) {
        this.page = menuPage;
        this.setFBAValue(0, n2);
        this.setFBAValue(7, n2);
        this.setFBAValue(1, n2);
        if (nArray != null) {
            this.m_colors = new int[nArray.length];
            this.m_effectColors = new int[nArray2.length];
            System.arraycopy(nArray, 0, this.m_colors, 0, nArray.length);
            System.arraycopy(nArray2, 0, this.m_effectColors, 0, nArray2.length);
        }
        this.m_dynamicFont = bl;
        if (this.m_dynamicFont && nArray3 != null) {
            this.m_fontFace = new int[nArray3.length];
            System.arraycopy(nArray3, 0, this.m_fontFace, 0, nArray3.length);
            this.m_fontStyle = new int[nArray4.length];
            System.arraycopy(nArray4, 0, this.m_fontStyle, 0, nArray4.length);
            this.m_fontSize = new int[nArray5.length];
            System.arraycopy(nArray5, 0, this.m_fontSize, 0, nArray5.length);
        }
        this.setContent(string, n);
    }

    public int getWidth() {
        int n = this.getFBAValue(10);
        if (this.getFBAValue(6) == 512) {
            ContentItem contentItem = this.content;
            if (contentItem != null) {
                n = contentItem.m_widestLine + this.getFBAValue(11) * 2;
            }
        } else if (this.page != null && this.getFBAValue(9) == 8192) {
            n = this.page.getContentAreaWidth();
        }
        return n;
    }

    public int getHeight() {
        ContentItem contentItem = this.content;
        return (contentItem != null ? contentItem.m_height : 0) + this.getFBAValue(11) * 2;
    }

    public void draw(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = this.getFBAValue(11);
        ContentItem contentItem = this.content;
        if (contentItem == null) {
            return;
        }
        if (this.getFBAValue(6) == 512) {
            n -= contentItem.m_width - contentItem.m_widestLine >> 1;
        }
        if (this.m_colors == null) {
            contentItem.draw(graphics, n + n3, n2 + n3, this.getFBAValue(this.enabled ? (bl ? 15 : 12) : (bl ? 17 : 16)), this.getFBAValue(13));
        } else {
            if (this.m_dynamicFont) {
                contentItem.m_font = Font.getFont((int)this.m_fontFace[0], (int)this.m_fontStyle[0], (int)this.m_fontSize[0]);
            }
            contentItem.draw(graphics, n + n3, n2 + n3, this.m_colors[0], this.m_effectColors[0], 0, 1, true);
            for (int i = 1; i < this.m_colors.length; ++i) {
                if (this.m_dynamicFont) {
                    contentItem.m_font = Font.getFont((int)this.m_fontFace[i], (int)this.m_fontStyle[i], (int)this.m_fontSize[i]);
                }
                contentItem.draw(graphics, n + n3, n2 + n3, this.m_colors[i], this.m_effectColors[i], i, i + 1, false);
            }
        }
    }

    public boolean isSelectable() {
        return this.action != -1 || this.pageLink != -1;
    }

    public void focusChange(boolean bl) {
    }

    public boolean keyPressed(int n) {
        return false;
    }

    public void typingInput(int n, int n2, char c) {
    }

    public int performAction() {
        if (this.action != -1) {
            return Core.postAction(this.action, this);
        }
        if (this.pageLink != -1) {
            Core.setCanvasController(MenuPage.getMenuPage(this.pageLink), false);
        }
        return -1;
    }

    public void setFBAValue(int n, int n2) {
        this.m_formattingBlockA = MenuPage.createFormattingBlock(n, n2, this.m_formattingBlockA, 1);
    }

    public int getFBAValue(int n) {
        if (this.page == null || MenuPage.isFormattingBlockValueSpecified(n, this.m_formattingBlockA)) {
            return MenuPage.getFormattingBlockValue(n, this.m_formattingBlockA, 1);
        }
        return MenuPage.getFormattingBlockValue(n, this.page.m_formattingBlockA, 1);
    }

    public void setContent(String string, int n) {
        if (string == null) {
            string = "";
        }
        ContentItem contentItem = this.content;
        this.content = null;
        int n2 = this.getWidth();
        this.content = contentItem;
        n2 -= this.getFBAValue(11) * 2;
        int n3 = 0;
        for (int i = 0; i < 10; ++i) {
            n3 |= this.getFBAValue(i);
        }
        this.content = new ContentItem(string, n2, n3, n);
    }
}

