/*
 * Decompiled with CFR 0.152.
 */
package com.override.util.mt;

public class ReusableThread
implements Runnable {
    public static final byte STATE_READY = 0;
    public static final byte STATE_STARTED = 1;
    public static final byte STATE_DESTROYED = 2;
    byte mState;
    Thread mThread;
    Runnable mProc;
    ThreadStateListener mListener;

    public ReusableThread(Runnable proc) {
        this.mProc = proc;
        this.mListener = null;
        this.mThread = new Thread(this);
        this.mState = 0;
    }

    public byte getState() {
        return this.mState;
    }

    public void setStateListener(ThreadStateListener listener) {
        this.mListener = listener;
    }

    public synchronized boolean setProcedure(Runnable proc) {
        if (this.mState == 0) {
            this.mProc = proc;
            return true;
        }
        return false;
    }

    public synchronized boolean start() {
        if (this.mState == 0) {
            this.mState = 1;
            if (!this.mThread.isAlive()) {
                this.mThread.start();
            }
            this.notify();
            return true;
        }
        return false;
    }

    public synchronized void destroy() {
        this.mState = (byte)2;
        this.notify();
        this.mThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            ReusableThread reusableThread = this;
            synchronized (reusableThread) {
                try {
                    while (this.mState != 1) {
                        if (this.mState == 2) {
                            return;
                        }
                        this.wait();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.mProc != null) {
                this.mProc.run();
            }
            if (this.mListener != null) {
                this.mListener.onRunOver(this);
            }
            reusableThread = this;
            synchronized (reusableThread) {
                if (this.mState == 2) {
                    return;
                }
                this.mState = 0;
            }
        }
    }

    public static interface ThreadStateListener {
        public void onRunOver(ReusableThread var1);
    }
}

